
/*:

@target MZ
@plugindesc 特定のキーが押されている間、メッセージウィンドウを透明にします。
@author メロウ紙芝居
@url https://meroukamisibai.com/

@param keyCode
@text キーコード
@desc メッセージウィンドウを透明にするキーのキーコード 。（例:83 = Sキー）
@type number
@default 83

@help MK_MessageWindowHide.js

特定のキーが押されている間、メッセージウィンドウを透明にします。
透明になるだけなので、透明にした状態で決定キーなどを押すと話が進みます。

*/

(() => {
    
    const pluginName = "MK_MessageWindowHide";
    
    //キー操作追加
    const parameters = PluginManager.parameters(pluginName);
    Input.keyMapper[Number(parameters["keyCode"])] = "mk_messageWindowHide";
    
    //特定のキー押されてると透明化
    Window_Message.prototype.MK_MessageWindowHide_Hide = function() {
        if(Input.isPressed("mk_messageWindowHide")){
            this.contentsOpacity = 0;
            this.opacity = 0;
            this.hideBackgroundDimmer();
            this._nameBoxWindow.contentsOpacity = 0;
            this._nameBoxWindow.opacity = 0;
            this._nameBoxWindow.hideBackgroundDimmer();
        }else{
            this.setBackgroundType(this._background);
            this.contentsOpacity = 255;
            this._nameBoxWindow.setBackgroundType(this._background);
            this._nameBoxWindow.contentsOpacity = 255;
        }
    };
    
    //メッセージウィンドウ更新
    const _Window_Message_update = Window_Message.prototype.update;
    Window_Message.prototype.update = function() {
        this.MK_MessageWindowHide_Hide();
        _Window_Message_update.apply(this, arguments);
    };
    
    //メッセージウィンドウ出す
    const _Window_Message_startMessage = Window_Message.prototype.startMessage;
    Window_Message.prototype.startMessage = function() {
        _Window_Message_startMessage.apply(this, arguments);
        this.MK_MessageWindowHide_Hide();
    };
    
})();
